function [m se] = plotAverageResponse_forPaper(total, numFrames, frameRate, labels, tit, raw, stimOn, stimOff,yBar)

%yBar = 140; %175 for typical M1 totalRel experiments, ~140 for pm tip and ~70 for pm bulb, 
color = [0 0 0] ./ 255; 
%color = [98 0 255] ./ 255;

colors = [ 0    0    0;
          0    0    1.0;
           %0    0.69 0.31; 
           %1.0  0.35 0;
           %1 1 0 %yellow
           1.0  0    0; %red
           0.73 0.20 1.0;];
            
            
shading = [ .8  .8  .8;
          .8  .8 1.0;
           % .8 1.0  .9;
          % 1.0  .9  .8;
           1.0  .8  .8; %red
            .9  .8 1.0;];

% Each cell in total contains a 2-D array of time vs. cell
for i = 1:length(total)
    m(:,i) = mean(total{i}, 2);
    se(:,i) = std(total{i}, 0, 2) / sqrt(size(total{i}, 2));
end

if (~strcmp(raw, 'raw'))
    m = m .* 100;
    se = se .* 100;
end

figure;
hold on;

x = (0:(numFrames-1)) / frameRate;

h = [];
for i=1:length(labels)
    p = patch([x x(end:-1:1)], cat(1, m(:,i)+se(:,i), m(end:-1:1,i)-se(end:-1:1,i)), ...
        shading(i,:), 'LineStyle', 'none');
end
for i=1:length(labels)
    h(i) = plot(x, m(:,i), 'LineWidth', 2.3, 'Color', colors(i,:)); %this is the width of the data lines, increased from 2 to 2
end

%set(gca,'YTick',[0 75 150 225 300]) %added to change y axis labels SRS

set(gca,'YTick',[0 40 80 120 160]) %labels for nEx3045
%set(gca,'YTick',[0 75 150 225 300]) %labels for cuIs36
%set(gca,'YTick',[-40 -20 0 20 40]) %labels for vkEx1241


if (stimOn >= 0)
    plot([stimOn stimOff], [yBar yBar], 'LineWidth', 30, 'Color', color);
    text((stimOn+stimOff)/2, yBar, ...
        ['Light'],...
        'FontWeight', 'bold', 'FontSize', 20, 'Color', [1 1 1], ...
        'HorizontalAlignment', 'center');
end

    set(gca, 'FontSize', 17);
    set(gca, 'FontName', 'Arial');
set(gca, 'LineWidth', 2.3); %this sets the axes to be darker to match the behavior plots for neuron formatting SRS 7/15/19

if (strcmp(raw, 'raw'))
    ylabel('fluorescence (au)', 'FontWeight', 'bold', 'FontSize', 20);
else
    ylabel('F/F_0 (%)', 'FontWeight', 'normal', 'FontSize', 21);
end
xlabel('time (s)', 'FontWeight', 'normal', 'FontSize', 21);
%title(tit, 'FontWeight', 'bold', 'FontSize', 20);
prettify;
legend(h, labels);
ylim([-5 160]); %(I used [-5 160] for nEx3045 and nIs686, [-5 350] for cuIs36

end